#!/bin/csh -f



#####**************************************************************************#####
#Despcription: This program is used to cut the residues in a pdb file to ALA 
#Copyright@LBEMSB,IBP
#Author: Kai Zhang
#Last Edit: 2009-3-16

#####**************************************************************************#####

#global setup for output format
set KBold="\x1b\x5b1m"
set KDefault="\x1b\x5b0m"
set KUnderline="\x1b\x5b4m"
set KFlash="\x1b\x5b5m"

#end of global setup


set args = `echo $argv | wc | awk '{print $2}'`
set Proc_name=`echo $0 | awk '{n=split($1,scr,"/");print scr[n];}'`


if ( $args == 0 || $1 == '--help' || $1 == '-h' ) then

	printf "${KBold}Despcription: ${KDefault}This program is used to generate a mapmam mask from a ccp4 map and pdb.\n"
	printf "${KBold}Usage:${KDefault}   $Proc_name  <input map file> <input pdb file> [output map file]\n"
	printf "${KBold}Example:${KDefault} $Proc_name  beta_cell.map beta_refined.pdb beta_mymask.mask\n"
	printf "         $Proc_name  beta_cell.map beta_refined.pdb\n"

	exit(1)
endif


##### Allocate enough memory in the RAVE programs for your maps and masks

setenv MAPSIZE  100000000
setenv MASKSIZE 100000000


set input_map_file=${1}
set input_pdb_file=${2}


set e_name = `echo $1 | awk '{n=split($1,scr,".");print toupper(scr[n]);}'`

if ( ${#argv} == 2 ) then

	if ( $e_name == "MAP" ) then

		set map_file_len=`echo $input_map_file |wc|awk '{print $3}'`
		@ map_file_len=$map_file_len - 5
		set input_map_file_cut=`echo $input_map_file |cut -c 1-$map_file_len`
		set output_mask_file=${input_map_file_cut}.mask

	else if ( $e_name == "CCP4") then

		set map_file_len=`echo $input_map_file |wc|awk '{print $3}'`
		@ map_file_len=$map_file_len - 6
		set input_map_file_cut=`echo $input_map_file |cut -c 1-$map_file_len`
		set output_mask_file=${input_map_file_cut}.mask

	else
		set output_mask_file=${input_map_file}.mask

	endif

endif

if  ( ${#argv} >= 3 ) then
set output_mask_file=${3}
endif


$CBIN/mapdump MAPIN $input_map_file <<end_ip > initMap_dump_$$.log
GO
END
end_ip

#### Grid info of initial map ####

set Cell=`awk '/Cell dimensions/ {print $4,$5,$6,$7,$8,$9}' initMap_dump_$$.log`

set Fast=`awk '/Fast, medium, slow axes ........................./{print $6}' initMap_dump_$$.log`
set Medium=`awk '/Fast, medium, slow axes ........................./{print $7}' initMap_dump_$$.log`
set Slow=`awk '/Fast, medium, slow axes ........................./{print $8}' initMap_dump_$$.log`


echo $Fast $Medium $Slow
#echo $Grid
if ( $Fast == 'X' && $Medium == 'Y' && $Slow == 'Z' ) then
set xyzLIM=`awk '/Start and stop points on columns, rows, sections/ {print $9,$10,$11,$12,$13,$14}' initMap_dump_$$.log`
set Grid=`awk '/Number of columns, rows, sections/ {print $7,$8,$9}' initMap_dump_$$.log`

else if ( $Fast == 'X' && $Medium == 'Z' && $Slow == 'Y' ) then
set xyzLIM=`awk '/Start and stop points on columns, rows, sections/ {print $9,$10,$13,$14,$11,$12}' initMap_dump_$$.log`
set Grid=`awk '/Number of columns, rows, sections/ {print $7,$9,$8}' initMap_dump_$$.log`

else if ( $Fast == 'Z' && $Medium == 'X' && $Slow == 'Y' ) then
set xyzLIM=`awk '/Start and stop points on columns, rows, sections/ {print $11,$12,$13,$14,$9,$10}' initMap_dump_$$.log`
set Grid=`awk '/Number of columns, rows, sections/ {print $8,$9,$7}' initMap_dump_$$.log`

else if ( $Fast == 'Z' && $Medium == 'Y' && $Slow == 'X' ) then
set xyzLIM=`awk '/Start and stop points on columns, rows, sections/ {print $13,$14,$11,$12,$9,$10}' initMap_dump_$$.log`
set Grid=`awk '/Number of columns, rows, sections/ {print $9,$8,$7}' initMap_dump_$$.log`

else if ( $Fast == 'Y' && $Medium == 'X' && $Slow == 'Z' ) then
set xyzLIM=`awk '/Start and stop points on columns, rows, sections/ {print $11,$12,$9,$10,$13,$14}' initMap_dump_$$.log`
set Grid=`awk '/Number of columns, rows, sections/ {print $8,$7,$9}' initMap_dump_$$.log`

else if ( $Fast == 'Y' && $Medium == 'Z' && $Slow == 'X' ) then
set xyzLIM=`awk '/Start and stop points on columns, rows, sections/ {print $13,$14,$9,$10,$11,$12}' initMap_dump_$$.log`
set Grid=`awk '/Number of columns, rows, sections/ {print $9,$7,$8}' initMap_dump_$$.log`

endif

echo $Grid
echo $xyzLIM 

/bin/rm initMap_dump_$$.log



#mask generating begin

lx_mama -b <<EOF
new cell $Cell
new grid $Grid
new pdb m1 $input_pdb_file
new rad 10
list m1
expnd m1
fill m1
contract m1
island m1
list m1
wr m1 $output_mask_file
quit
EOF

#end of program
