#!/bin/tcsh -f

##### This program is to carry out multi-crystal average #####

setenv CBIN `sed -n 1p information.txt | awk '{print $1}'`

##### generate input parameters #####

set mtz_dir=`sed -n 3p information.txt | awk '{print $1}'`
set cry_num=`sed -n 5p information.txt | awk '{print $1}'`
set mask_pdb=`sed -n 6p information.txt | awk '{print $1}'`
set identifier=`sed -n 2p information.txt | awk '{print $1}'`
set work_dir=`sed -n 4p information.txt | awk '{print $1}'`
set cycle_num=`sed -n 7p information.txt | awk '{print $1}'`
set mask_pdb_sup=mask.pdb
set mask_mask=mask.mask		#output mask map
set mask_msk=mask.msk		#output mask map in ccp4 format

set i=1
while ( $i <= $cry_num )
set k=`expr $i + 7`
ln -s $mtz_dir/`sed -n ${k}p information.txt | awk '{print $1}'` cryin${i}.mtz
ln -s $mtz_dir/`sed -n ${k}p information.txt | awk '{print $2}'` cryin${i}.pdb
@ i++
end

####################################################################################################
##### examine the existance of some files #####

if ( ! -e information.txt ) then
	echo ERROR ... file information.txt not found ... aborting
	exit -1
endif
if ( ! -e $mask_pdb ) then
	echo ERROR ... file $mask_pdb not found ... aborting
	exit -1
endif
if ( ! -e mask_gener.com ) then
	echo ERROR ... file mask_gener.com not found ... aborting
	exit -1
endif
if ( ! -e omap2ccp4.com ) then
	echo ERROR ... file omap2ccp4.com not found ... aborting
	exit -1
endif 
if (! -e crave_head.txt ) then
	echo ERROR ... file crave_head.txt not found ... aborting
	exit -1 
endif

set i=1
while ( $i <= $cry_num )
set k=`expr $i + 7 `
set sym=`sed -n ${k}p information.txt | awk '{print $4}'`

	if ( ! -e $sym.sym ) then
	echo ERROR ... file $sym.sym not found ... aborting
	exit -1
	endif

@ i++
end
##################################################
####################################################################################################
##### convert mtz format to map format #####

set LRes=50
set HRes=2.3
set F=F
set SIGF=SIGF
set output_map_asu="tmp.map"

##################################################

echo " ...... start mtz2map "

set i=1
while ( $i <= $cry_num )
echo "Running fft... Calculating initial map ${i}"

set k=`expr $i + 7`
set SYMMETRY=`sed -n ${k}p information.txt | awk '{print $3}'`

$CBIN/fft HKLIN  cryin${i}.mtz  MAPOUT  $output_map_asu \
          <<end_ip  >> fft.log 
TITLE calculate new map
RESOLUTION $LRes $HRes
xyzlim asu
scale F1 1.0
labin F1=$F SIG1=$SIGF PHI=PHIC W=FOM
end_ip

mapmask MAPIN $output_map_asu MAPOUT cryin${i}.map <<eof >> fft.log
SYMMETRY $SYMMETRY
AXIS Z X Y
XYZLIM CELL
eof
rm $output_map_asu

@ i++
end

echo " ...... end of mtz2map"
##################################################
####################################################################################################
##### ncs operater gener #####
echo " ...... start generate ncs operater "

set i=1
while ( $i <= $cry_num )
echo " ......begin pdbsplit pdb ${i} "

set k=`expr $i + 7`
set num_chain=`sed -n ${k}p information.txt | awk '{print $5}'`
pdbsplit cryin${i}.pdb |tee >>pdbsplit.log

  set m=1
  while ( $m <= $num_chain )
  mv ?${m}.pdb cryin${i}_${m}.pdb

  @ m++
  end

  set m=2
  while ( $m <= $num_chain )
  ncs_op_gener cryin${i}_1.pdb cryin${i}_${m}.pdb cry${i}_1_cry${i}_${m}.o

  @ m++
  end

@ i++
end

set i=2
while ( $i <= $cry_num )

ncs_op_gener cryin1_1.pdb cryin${i}_1.pdb cry1_1_cry${i}_1.o

@ i++
end

ncs_op_gener cryin1_1.pdb cryin1_1.pdb rt_unit.o

echo " ...... end of generate ncs operater "
##################################################
####################################################################################################
##### prepare mask map #####
echo " ...... start prepare mask map "


superpose $mask_pdb cryin1_1.pdb $mask_pdb_sup
./mask_gener.com cryin1.map $mask_pdb_sup $mask_mask
mama2ccp4 maskin $mask_mask maskout $mask_msk

echo " ...... end of prepare mask map "
##################################################
####################################################################################################
##### generate C-shell script for RAVE: crave_auto.com #####

echo " ...... start generate C-shell script for RAVE"

cp crave_head.txt crave_auto.com

echo "! your work directory" >> crave_auto.com
echo "WORK $work_dir" >> crave_auto.com
echo "! identifier" >> crave_auto.com
echo "IDEN $identifier" >> crave_auto.com
echo "! number of cycles" >> crave_auto.com
echo "CYCL $cycle_num" >> crave_auto.com
echo "! scratch directory" >> crave_auto.com
echo "SCRA $work_dir/scratch" >> crave_auto.com
echo "! mask in reference crystal" >> crave_auto.com
echo "mask.mask" >> crave_auto.com
echo "!" >> crave_auto.com

set i=1
while ( $i <= $cry_num )

set k=`expr $i + 7 `
set sym=`sed -n ${k}p information.txt | awk '{print $4}'`
set num_chain=`sed -n ${k}p information.txt | awk '{print $5}'`

$CBIN/mapdump mapin cryin${i}.map <<end-mapdump | tee mapdump${i}.log
GO
END
end-mapdump

set xGrid=`awk '/Grid sampling on x, y, z/ {print $8}' mapdump${i}.log`
set yGrid=`awk '/Grid sampling on x, y, z/ {print $9}' mapdump${i}.log`
set zGrid=`awk '/Grid sampling on x, y, z/ {print $10}' mapdump${i}.log`
set start_x=`awk '/Start and stop points on columns, rows, sections/ {print $11}' mapdump${i}.log`
set stop_x=`awk '/Start and stop points on columns, rows, sections/ {print $12}' mapdump${i}.log`
set start_y=`awk '/Start and stop points on columns, rows, sections/ {print $13}' mapdump${i}.log`
set stop_y=`awk '/Start and stop points on columns, rows, sections/ {print $14}' mapdump${i}.log`
set start_z=`awk '/Start and stop points on columns, rows, sections/ {print $9}' mapdump${i}.log`
set stop_z=`awk '/Start and stop points on columns, rows, sections/ {print $10}' mapdump${i}.log`

rm mapdump${i}.log

	if ( "$i" == "1" ) then
	echo "! data for crystal form $i (reference)" >> crave_auto.com
	else 
	echo "! data for crystal form $i (target)" >> crave_auto.com

	endif

echo "!" >> crave_auto.com
echo "! identifier" >> crave_auto.com
echo "COPY ${sym}_${i}" >> crave_auto.com
echo "! mtz file" >> crave_auto.com
echo "MTZ  cryin${i}.mtz" >> crave_auto.com
echo "! input unit cell map" >> crave_auto.com
echo "MAP  cryin${i}.map" >> crave_auto.com
echo "! mtz file labels for f and sigf" >> crave_auto.com
echo "LABF F" >> crave_auto.com
echo "SIGF SIGF" >> crave_auto.com
echo "! fft grid and extent" >> crave_auto.com
echo "GRID $xGrid $yGrid $zGrid" >> crave_auto.com
echo "EXTE $start_x $stop_x $start_y $stop_y $start_z $stop_z" >> crave_auto.com
echo "! resolution" >> crave_auto.com
echo "RESO 30 2.3" >> crave_auto.com
echo "! O symm-op file" >> crave_auto.com
echo "OSYM ${sym}.sym" >> crave_auto.com
echo "! all ncs operators" >> crave_auto.com
echo "NCSO rt_unit.o" >> crave_auto.com

	set m=2
	while ( $m <= $num_chain )
	echo "NCSO cry${i}_1_cry${i}_${m}.o" >> crave_auto.com

	@ m++
	end

	if ( "$i" == "1" ) then
	echo "! cross-crystal operator (= unit oper for form 1)" >> crave_auto.com
	echo "XXRT rt_unit.o" >> crave_auto.com

	else  
	echo "! cross-crystal operator" >> crave_auto.com
	echo "XXRT cry1_1_cry${i}_1.o" >> crave_auto.com

	endif

echo "!" >> crave_auto.com

@ i++
end

echo "! output C-shell script" >> crave_auto.com
echo "FILE ${identifier}_mcrave.csh" >> crave_auto.com
echo "eof" >> crave_auto.com

echo "sed -i 's/NGAU 2//g' ${identifier}_mcrave.csh" >> crave_auto.com
echo "sed -i 's/m1.mask/mask.mask/g' ${identifier}_mcrave.csh" >> crave_auto.com
echo "sed -i 's/ASIN/ALLIN/g' ${identifier}_mcrave.csh" >> crave_auto.com
echo "chmod 755 ${identifier}_mcrave.csh" >> crave_auto.com
echo "./${identifier}_mcrave.csh" >> crave_auto.com

echo " ...... end of generate C-shell script for RAVE"
##################################################
####################################################################################################

mkdir scratch
mkdir log
chmod 755 crave_auto.com
./crave_auto.com

mv *.log log
rm cryin?_?.pdb
rm cryin?.mtz
rm cryin?.pdb

./omap2ccp4.com final.omap final.map












